UPDATE
	PG_CRED_FORN
SET
	DT_CAD=CONVERT(VARCHAR(10),DT_CAD,112)
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PG_CRED_FORN_GERACAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PG_CRED_FORN_GERACAO]
GO
CREATE PROCEDURE P_PG_CRED_FORN_GERACAO AS 
CREATE TABLE  #RsNotas (ORDEM INT IDENTITY (1, 1), 
						CD_EMP INT, 
						CD_FILIAL INT, 
						CD_NF INT,
						CD_FORN INT,
						VLR_CREDITO MONEY,
						DT_CREDITO DATETIME,
						CD_USU INT)
DECLARE @CD_CONTROLE INT
SET @CD_CONTROLE = ISNULL((SELECT MAX(CD_CRED_FORN) FROM PG_CRED_FORN WHERE CD_EMP = 1),0)

INSERT INTO #RsNotas (CD_EMP, CD_FILIAL, CD_NF, CD_FORN, VLR_CREDITO, DT_CREDITO, CD_USU) 
SELECT
	V_EST_NF_SAI_CAB.CD_EMP,
	V_EST_NF_SAI_CAB.CD_FILIAL,
	V_EST_NF_SAI_CAB.CD_NF,
	V_EST_NF_SAI_CAB.CD_CLI,
	V_EST_NF_SAI_CAB.VLR_NF,
	V_EST_NF_SAI_CAB.DT_EMI_NF,
	V_EST_NF_SAI_CAB.CD_USU
FROM
	V_EST_NF_SAI_CAB LEFT OUTER JOIN PG_CRED_FORN_EST_NF_SAI ON
	V_EST_NF_SAI_CAB.CD_EMP = PG_CRED_FORN_EST_NF_SAI.CD_EMP AND
	V_EST_NF_SAI_CAB.CD_FILIAL = PG_CRED_FORN_EST_NF_SAI.CD_FILIAL AND
	V_EST_NF_SAI_CAB.CD_NF = PG_CRED_FORN_EST_NF_SAI.CD_NF
	INNER JOIN PG_FORN ON
	V_EST_NF_SAI_CAB.CD_EMP = PG_FORN.CD_EMP AND
	V_EST_NF_SAI_CAB.CD_CLI = PG_FORN.CD_FORN 
WHERE
	V_EST_NF_SAI_CAB.CD_EMP =1
	AND V_EST_NF_SAI_CAB.TP_MOV in (41,11)
	AND V_EST_NF_SAI_CAB.STS_NF=0
	AND PG_CRED_FORN_EST_NF_SAI.CD_NF  IS NULL

INSERT INTO PG_CRED_FORN
(CD_EMP,
CD_CRED_FORN,
CD_FORN,
DT_CRED,
VLR_CRED,
CD_USU,
DT_CAD,
DT_ULT_ALT,
DS_HIST,
STS_CRED_FORN,
CONCILIADO)
SELECT 
	CD_EMP,
	ORDEM + @CD_CONTROLE,
	CD_FORN,
	DT_CREDITO,
	VLR_CREDITO,
	CD_USU,
	CONVERT(VARCHAR(10),GETDATE(),112),
	NULL,
	'',
	0,
	0
FROM
	#RsNotas


INSERT INTO PG_CRED_FORN_EST_NF_SAI
SELECT 
	CD_EMP,
	CD_FILIAL,
	ORDEM + @CD_CONTROLE,
	CD_NF
FROM
	#RsNotas

DROP TABLE #RsNotas